
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_CautionTag : BaseTest 
	{
		private DataTable  _dtPatient = null;
		private DataTable  _dtBloodUnit = null;


		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Patient");
				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
				this.RefreshData = false;
			}

		}

		[Test]
		public void InsertExceptionReport_Pass()
		{		
			DataTable dtTest = new DataTable(TABLES.ExceptionCautionTag.TableName);

			dtTest.Columns.Add(TABLES.ExceptionCautionTag.ExceptionCautionTagGuid, typeof(System.Guid));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.ExceptionTypeId, typeof(int));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.PatientGuid, typeof(System.Guid));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.UnitGuid, typeof(System.Guid));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.PatientName, typeof(string));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.PatientId, typeof(string));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.PatientAboRh, typeof(string));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.UnitAboRh , typeof(string));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.UnitId, typeof(string));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.ProductCode, typeof(string));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.UnitExpirationDate, typeof(System.DateTime));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.ExceptionUser, typeof(string));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.ExceptionComment, typeof(string));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.ExceptionDate, typeof(System.DateTime));
			dtTest.Columns.Add(TABLES.ExceptionCautionTag.DivisionCode, typeof(string));

			DataRow drNew = dtTest.NewRow();

			drNew[TABLES.ExceptionCautionTag.ExceptionCautionTagGuid] = System.Guid.NewGuid();
			drNew[TABLES.ExceptionCautionTag.ExceptionTypeId] = (int)Common.ExceptionType.CautionTag_BTRF_expired_unit;
			drNew[TABLES.ExceptionCautionTag.PatientGuid] = this._dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			drNew[TABLES.ExceptionCautionTag.UnitGuid] = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			drNew[TABLES.ExceptionCautionTag.PatientName] = this._dtPatient.Rows[0][TABLES.Patient.PatientFirstName] + " Simpson";
			drNew[TABLES.ExceptionCautionTag.PatientId] = this._dtPatient.Rows[0][TABLES.Patient.PatientSsn];
			drNew[TABLES.ExceptionCautionTag.PatientAboRh] = "A Pos";
			drNew[TABLES.ExceptionCautionTag.UnitAboRh] = "A Pos";
			drNew[TABLES.ExceptionCautionTag.UnitId] = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.EyeReadableUnitId];
			drNew[TABLES.ExceptionCautionTag.ProductCode] = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.UnitProductCode];
			drNew[TABLES.ExceptionCautionTag.UnitExpirationDate] = System.DateTime.Now.AddYears(1);
			drNew[TABLES.ExceptionCautionTag.ExceptionUser] = Common.LogonUser.LogonUserName;
			drNew[TABLES.ExceptionCautionTag.ExceptionComment] = "UnitTest - " + System.DateTime.Now.ToString();
			drNew[TABLES.ExceptionCautionTag.ExceptionDate] = System.DateTime.Now;
			drNew[TABLES.ExceptionCautionTag.DivisionCode] = this.TestDivisionCode;
			dtTest.Rows.Add(drNew);

			int retValue = DAL.CautionTag.InsertExceptionReport(dtTest);

			Assert.AreEqual(0, retValue, "ReturnValue");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InsertExceptionReport_Fail()
		{		
		}

        
	}
}
#endif
